﻿/*
Post-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be appended to the build script.		
 Use SQLCMD syntax to include a file in the post-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the post-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/

-- The CDW envrionment requires that any stored procedure or function in the
-- App schema executed by the App account (CC_REFDOC_APP) and referencing
-- anything in the CDWWork database be signed. If only items in the project
-- database (any schema) are referenced, it need not be signed.

-- Commented out items below used to require signing, but with refactoring
-- they no longer do. Left in the file and commented to be an affirmative
-- statement that they do not need to be signed rather than that they were
-- overlooked.

exec dbo.sp_SignAppObject 'NVCC_Rebuild_SensitiveDxCodesTable'
exec dbo.sp_SignAppObject 'NVCC_usp_CurrentUsage'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAllergies'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAnnouncement'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAppts'
exec dbo.sp_SignAppObject 'NVCC_usp_GetConsults'
exec dbo.sp_SignAppObject 'NVCC_usp_GetDivision'
exec dbo.sp_SignAppObject 'NVCC_usp_GetDivisions'
exec dbo.sp_SignAppObject 'NVCC_usp_GetLabs'
exec dbo.sp_SignAppObject 'NVCC_usp_GetNextOfKin'
exec dbo.sp_SignAppObject 'NVCC_usp_GetNVAMeds'
exec dbo.sp_SignAppObject 'NVCC_usp_GetPatient'
exec dbo.sp_SignAppObject 'NVCC_usp_GetPatientBySid'
exec dbo.sp_SignAppObject 'NVCC_usp_GetProbs'
exec dbo.sp_SignAppObject 'NVCC_usp_GetSensDx'
exec dbo.sp_SignAppObject 'NVCC_usp_GetVAMeds'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwFacility'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwFacilityBySta3n'
exec dbo.sp_SignAppObject 'NVCC_usp_GetXdwUser'
--exec dbo.sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueSta3n'
exec dbo.sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueUsers'
exec dbo.sp_SignAppObject 'NVCC_usp_UniqueVeterans'
exec dbo.sp_SignAppObject 'NVCC_usp_UsageData2'
exec dbo.sp_SignAppObject 'NVCC_usp_Get_UsersByFacility'
exec dbo.sp_SignAppObject 'NVCC_usp_GetVisn'
exec dbo.sp_SignAppObject 'NVCC_usp_GetROIAdminSearch'
exec dbo.sp_SignAppObject 'NVCC_usp_GetUserNameBySta3n'
exec dbo.sp_SignAppObject 'NVCC_usp_GetPatientsByPartialNameAndSsn'
exec dbo.sp_SignAppObject 'NVCC_usp_GetAuthorizedROIAdminUser'
--exec dbo.sp_SignAppObject 'NVCC_usp_UserCounts'
--exec dbo.sp_SignAppObject 'NVCC_udf_ActiveUserCount'
